<?php
session_start();
ob_start(); // Start output buffering to prevent header issues
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check if dbconfig.php exists and include it
if (!file_exists('../dbconfig/dbconfig.php')) {
    die("Error: Database configuration file not found.");
}
require '../dbconfig/dbconfig.php';

// Verify database connection
if (!$conn) {
    die("Error: Database connection failed: " . mysqli_connect_error());
}

// Ensure the session is active and user is an admin
// if (!isset($_SESSION['email']) || !isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
//     header("Location: login.php?error=unauthorized");
//     exit();
// }

// Fetch all orders with order details
$query = "SELECT 
    ord.order_id, 
    CONCAT(ord.first_name, ' ', ord.last_name) AS Name, 
    CONCAT(ord.address_line1, ' ', ord.address_line2, ' ', ord.city, ' ', ord.postal_code) AS Address, 
    ord.contact_number,
    ord.email, 
    ord.payment_method, 
    od.item_name, 
    od.quantity, 
    od.price,
    (od.quantity * od.price) as total_price    
FROM orders ord 
LEFT JOIN order_details od ON ord.order_id = od.order_id;";
$stmt = $conn->prepare($query);

if (!$stmt) {
    die("Error preparing query: " . $conn->error);
}

if (!$stmt->execute()) {
    die("Error executing query: " . $stmt->error);
}

$result = $stmt->get_result();
if (!$result) {
    die("Error fetching results: " . $stmt->error);
}

if ($result->num_rows === 0) {
    header("Location: orders0.html");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel</title>
    <link rel="stylesheet" type="text/css" href="styles/adminPage.css">


    <!--  -->
    <style>
         body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        } 
      .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            width: 90%;
            max-width: 1200px;
            text-align: center;
        }
        h2 {
            margin-top: 0;
            color: #333;
        }
        .table-wrapper {
            overflow-x: auto;
            margin: 20px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            min-width: 1000px;
        }
        th, td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: left;
            white-space: nowrap;
        }
        th {
            background-color: #007bff;
            color: #fff;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .button-container {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }
        .btn-download {
            background-color: #28a745;
        }
        .btn-logout {
            background-color: #dc3545;
        }
        .btn:hover {
            opacity: 0.8;
        }
        .buttonl-container {
            position: absolute;
            top: 30px;
            right: 70px;
        }
        .btn-logout {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            background-color: #dc3545;
            color: #fff;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }
        .btn-logout:hover {
            opacity: 0.8; 
         }
    </style>
</head>
<body>
    <div class="container">
        <h2>Welcome</h2>
        <div class="buttonl-container">
            <a href="logout.php" class="btn btn-logout">Log Out</a>
        </div>
        <div style="max-height: 400px; overflow-y: auto; border: 1px solid #ccc;">
            <table>
                <thead>
                    <tr>
                        <th>Order ID</th>
                        <th>Name</th>
                        <th>Address</th>
                        <th>Contact</th>
                        <th>Email</th>
                        <th>Item Name</th>
                        <th>Quantity</th>
                        <th>Price</th>
                        <th>Sub Total Price</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['order_id'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars($row['Name'] , ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars($row['Address'] , ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars($row['contact_number'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars($row['email'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars($row['item_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars($row['quantity'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars($row['price'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars($row['total_price'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                            
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        <div class="button-container">
            <a href="download_csv.php" class="btn btn-download">Download</a>
        </div>
    </div>
    <?php
    // Clean up
    $stmt->close();
    $conn->close();
    ob_end_flush(); // Flush output buffer
    ?>
</body>
</html>