<?php
require '../dbconfig/dbconfig.php';

// Fetch all orders with individual item details from order_details
$query = "
    SELECT 
        o.order_id,
        o.first_name,
        o.last_name,
        o.address_line1,
        o.address_line2,
        o.city,
        o.postal_code,
        o.contact_number,
        o.email,
        od.item_name,
        od.quantity,
        od.price,
        (od.quantity * od.price) AS item_subtotal,
        o.total_price,
        o.payment_method,
        o.order_date
    FROM orders o
    LEFT JOIN order_details od ON o.order_id = od.order_id
    ORDER BY o.order_id, od.order_detail_id
";
$result = $conn->query($query);

if ($result->num_rows > 0) {
    $delimiter = ",";
    $filename = "orders_detailed_" . date('Y-m-d') . ".csv";

    // Create a file pointer
    $f = fopen('php://memory', 'w');

    // Set column headers
    $fields = array(
        'Order ID',
        'First Name',
        'Last Name',
        'Address Line 1',
        'Address Line 2',
        'City',
        'Postal Code',
        'Contact Number',
        'Email',
        'Item Name',
        'Quantity',
        'Price',
        'Item Subtotal',
        'Payment Method',
        'Order Date'
    );
    fputcsv($f, $fields, $delimiter);

    // Output each row of the data, format line as CSV and write to file pointer
    while ($row = $result->fetch_assoc()) {
        $lineData = array(
            $row['order_id'],
            $row['first_name'],
            $row['last_name'],
            $row['address_line1'],
            $row['address_line2'],
            $row['city'],
            $row['postal_code'],
            $row['contact_number'],
            $row['email'],
            $row['item_name'] ?? 'N/A', // Handle orders with no items
            $row['quantity'] ?? 0,
            $row['price'] ? number_format($row['price'], 2) : '0.00',
            $row['item_subtotal'] ? number_format($row['item_subtotal'], 2) : '0.00',
            $row['payment_method'],
            $row['order_date']
        );
        fputcsv($f, $lineData, $delimiter);
    }

    // Move back to beginning of file
    fseek($f, 0);

    // Set headers to download file rather than displayed
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="' . $filename . '";');

    // Output all remaining data on a file pointer
    fpassthru($f);

    // Close file pointer
    fclose($f);
} else {
    // Output a message if no orders are found
    header('Content-Type: text/plain');
    echo "No orders found.";
}

// Close database connection
$conn->close();
exit;
?>