<?php
require 'src/PHPMailer.php';
require 'src/Exception.php';
require 'src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function sendOrderConfirmationEmail($first_name, $last_name, $email, $cart_data, $total_price, $address_line1, $address_line2, $city, $postal_code, $contact_number, $order_id) {
    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->SMTPDebug = 0; // Set to 2 for debugging
        $mail->isSMTP();
        $mail->Host = 'smtp.office365.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'web@linknaturalproducts.com'; // Your Office 365 email address
        $mail->Password = 'ypfmvtbjfkknjwxc'; // Your Office 365 email password
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        // Recipients
        $mail->setFrom('web@linknaturalproducts.com', 'Swastha Wellness');
        $mail->addAddress($email, $first_name . ' ' . $last_name); // Main recipient
        $mail->addCC('chamari.f@lnp.lk'); // CC recipient

        // Load and populate the HTML template
        $template = file_get_contents(__DIR__ . '/email_template.html');

        // Build items list for the email
        $items_list = '';
        foreach ($cart_data as $item) {
            $subtotal = $item['quantity'] * $item['price'];
            $items_list .= "<li>" . htmlspecialchars($item['name']) . " x{$item['quantity']} - LKR " . number_format($subtotal, 2) . "</li>";
        }

        // Replace placeholders in the template
        $template = str_replace('{{first_name}}', htmlspecialchars($first_name), $template);
        $template = str_replace('{{last_name}}', htmlspecialchars($last_name), $template);
        $template = str_replace('{{items_list}}', $items_list, $template);
        $template = str_replace('{{total_price}}', number_format($total_price, 2), $template);
        $template = str_replace('{{address_line1}}', htmlspecialchars($address_line1), $template);
        $template = str_replace('{{address_line2}}', $address_line2 ? htmlspecialchars($address_line2) : '', $template);
        $template = str_replace('{{city}}', htmlspecialchars($city), $template);
        $template = str_replace('{{postal_code}}', htmlspecialchars($postal_code), $template);
        $template = str_replace('{{contact_number}}', htmlspecialchars($contact_number), $template);
        $template = str_replace('{{email}}', htmlspecialchars($email), $template);
        $template = str_replace('{{order_id}}', htmlspecialchars($order_id), $template);

        // Content
        $mail->isHTML(true);
        $mail->Subject = 'Order Confirmation #' . htmlspecialchars($postal_code) . ' - '.$order_id;
        $mail->Body = $template;

        $mail->send();
    } catch (Exception $e) {
        error_log("Message could not be sent. Mailer Error: {$mail->ErrorInfo}", 3, __DIR__ . '/errors.log');
        throw new Exception("Failed to send email: {$mail->ErrorInfo}");
    }
}
?>