<?php
// Assuming you have a database connection established
require 'dbconfig/dbconfig.php';

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch order details from the database
$sql = "SELECT order_id, order_date FROM orders WHERE contact_number = ? ORDER BY order_date DESC LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $contact_number);
$stmt->execute();
$stmt->bind_result($order_id, $order_date);
$stmt->fetch();
$stmt->close();
$conn->close();

$template = str_replace('{{order_id}}', $order_id, $template);
$template = str_replace('{{order_date}}', $order_date, $template);