<?php
// Start session to check for user login state
session_start();

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    // If not logged in, redirect to the login page
    header("Location: login.php");
    exit();
}

// Connect to database
require '../dbconfig/dbconfig.php';

// Pagination and filtering logic
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';
$page = isset($_GET['page']) ? $_GET['page'] : 1;
$limit = 10;
$offset = ($page - 1) * $limit;

// Query to fetch orders with status filter
$query = "SELECT * FROM orders";
if ($status_filter) {
    $query .= " WHERE status = '$status_filter'";
}
$query .= " LIMIT $limit OFFSET $offset";

$result = $conn->query($query);

// Get total number of orders for pagination
$total_query = "SELECT COUNT(*) AS total FROM orders";
if ($status_filter) {
    $total_query .= " WHERE status = '$status_filter'";
}
$total_result = $conn->query($total_query);
$total_row = $total_result->fetch_assoc();
$total_orders = $total_row['total'];
$total_pages = ceil($total_orders / $limit);

// Fetch statistics
$stats_query = "SELECT COUNT(*) AS total_orders, SUM(total_price) AS total_revenue, 
                       SUM(CASE WHEN status = 'completed' THEN total_price ELSE 0 END) AS completed_revenue,
                       SUM(CASE WHEN status = 'pending' THEN total_price ELSE 0 END) AS pending_revenue
                FROM orders";
$stats_result = $conn->query($stats_query);
$stats = $stats_result->fetch_assoc();

// Handling order status update
if (isset($_GET['update_status_id'])) {
    $update_id = $_GET['update_status_id'];
    $status_value = $_GET['status_value'];
    $update_query = "UPDATE orders SET status = '$status_value' WHERE order_id = $update_id";
    $conn->query($update_query);
}

// Handling order deletion
if (isset($_GET['delete_id'])) {
    $delete_id = $_GET['delete_id'];
    $delete_query = "DELETE FROM orders WHERE order_id = $delete_id";
    $conn->query($delete_query);
}
?>