<?php
// Include database connection and mail functionality
require 'dbconfig/dbconfig.php';
require 'MailFuntion/Mails.php';

// Default cart used if localStorage is empty
$default_cart = [
    ['id' => 1, 'name' => 'Swastha Amurtha', 'price' => 175.00, 'quantity' => 5, 'description' => 'Premium health supplement for vitality', 'image' => 'assets/product.jpg']
];

// Similar items array for recommended products
$similar_items = [
    [
        'id' => 2,
        'name' => 'Swastha Thriphala (30 Tablets)',
        'price' => 360.00,
        'description' => '<strong>Swastha Thriphala</strong>, a trusted Ayurvedic formula made with Aralu, Bulu, and Nelli, has been used for thousands of years to promote <strong>health, immunity, and longevity</strong> by supporting <strong>proper digestion, absorption, and elimination</strong> within the body. Discover its amazing benefits: <br>- <strong>Promotes proper digestion</strong> and harmonizes <strong>healthy metabolic functions</strong>. <br>- <strong>Significantly reduces blood cholesterol</strong>, especially bad cholesterol (when taken with Atorvastatin - clinically proven). <br>- <strong>Regulates proper bowel action</strong>. <br>- <strong>Improves liver function</strong>. <br>- <strong>Slows aging</strong> and supports <strong>youthfulness</strong>. <br><strong>Effective Remedy for</strong>: Bowel irregularity, constipation, indigestion, flatulence, hyperacidity, gastric irritation, regurgitation, lack of enthusiasm, fatigue, general debility, and lack of resistance to diseases. <br><strong>Directions for Use</strong>: <br>- For <strong>rejuvenation and health maintenance</strong>: 1-2 tablets twice daily as a wellness habit. <br>- For <strong>hyperacidity, gastric irritation, indigestion, flatulence, and stress-related disorders</strong>: 2 tablets twice daily as needed. <br>- For <strong>constipation and bowel irregularity</strong>: 2-4 tablets after dinner as required (start with 2 tablets at night, increase to 3 or 4 if needed). <br><strong>Note</strong>: Not to be taken when pregnant or if the patient has diarrhea.',
        'image' => 'assets/Swastha-Thriphala.jpg'
    ],
    [
        'id' => 3,
        'name' => 'Swastha Thriphala (60 Tablets)',
        'price' => 680.00,
        'description' => '<strong>Swastha Thriphala</strong>, a trusted Ayurvedic formula made with Aralu, Bulu, and Nelli, has been used for thousands of years to promote <strong>health, immunity, and longevity</strong> by supporting <strong>proper digestion, absorption, and elimination</strong> within the body. Discover its amazing benefits: <br>- <strong>Promotes proper digestion</strong> and harmonizes <strong>healthy metabolic functions</strong>. <br>- <strong>Significantly reduces blood cholesterol</strong>, especially bad cholesterol (when taken with Atorvastatin - clinically proven). <br>- <strong>Regulates proper bowel action</strong>. <br>- <strong>Improves liver function</strong>. <br>- <strong>Slows aging</strong> and supports <strong>youthfulness</strong>. <br><strong>Effective Remedy for</strong>: Bowel irregularity, constipation, indigestion, flatulence, hyperacidity, gastric irritation, regurgitation, lack of enthusiasm, fatigue, general debility, and lack of resistance to diseases. <br><strong>Directions for Use</strong>: <br>- For <strong>rejuvenation and health maintenance</strong>: 1-2 tablets twice daily as a wellness habit. <br>- For <strong>hyperacidity, gastric irritation, indigestion, flatulence, and stress-related disorders</strong>: 2 tablets twice daily as needed. <br>- For <strong>constipation and bowel irregularity</strong>: 2-4 tablets after dinner as required (start with 2 tablets at night, increase to 3 or 4 if needed). <br><strong>Note</strong>: Not to be taken when pregnant or if the patient has diarrhea.',
        'image' => 'assets/Swastha-Thriphala.jpg'
    ],
    [
        'id' => 4,
        'name' => 'Swastha Thriphala (120 Tablets)',
        'price' => 1000.00,
        'description' => '<strong>Swastha Thriphala</strong>, a trusted Ayurvedic formula made with Aralu, Bulu, and Nelli, has been used for thousands of years to promote <strong>health, immunity, and longevity</strong> by supporting <strong>proper digestion, absorption, and elimination</strong> within the body. Discover its amazing benefits: <br>- <strong>Promotes proper digestion</strong> and harmonizes <strong>healthy metabolic functions</strong>. <br>- <strong>Significantly reduces blood cholesterol</strong>, especially bad cholesterol (when taken with Atorvastatin - clinically proven). <br>- <strong>Regulates proper bowel action</strong>. <br>- <strong>Improves liver function</strong>. <br>- <strong>Slows aging</strong> and supports <strong>youthfulness</strong>. <br><strong>Effective Remedy for</strong>: Bowel irregularity, constipation, indigestion, flatulence, hyperacidity, gastric irritation, regurgitation, lack of enthusiasm, fatigue, general debility, and lack of resistance to diseases. <br><strong>Directions for Use</strong>: <br>- For <strong>rejuvenation and health maintenance</strong>: 1-2 tablets twice daily as a wellness habit. <br>- For <strong>hyperacidity, gastric irritation, indigestion, flatulence, and stress-related disorders</strong>: 2 tablets twice daily as needed. <br>- For <strong>constipation and bowel irregularity</strong>: 2-4 tablets after dinner as required (start with 2 tablets at night, increase to 3 or 4 if needed). <br><strong>Note</strong>: Not to be taken when pregnant or if the patient has diarrhea.',
        'image' => 'assets/Swastha-Thriphala.jpg'
    ]
];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Setting up meta tags for character encoding and responsive viewport -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shopping Cart</title>
    <!-- Including Google Fonts for Roboto -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <!-- Including Font Awesome for professional navigation icons and success message icon -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Including Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Including custom CSS for cart styling -->
    <link rel="stylesheet" href="styles/checkout.css">
    <!-- Adding inline CSS for slideshow, cards, modals, and enhanced success message -->
    <style>
        /* Styling the slideshow container for professional appearance */
        .slideshow-container {
            position: relative;
            width: 100%;
            max-width: 1200px;
            margin: auto;
            overflow: hidden;
            border-radius: 8px;
            background: #f9fafb;
            padding: 10px;
        }
        /* Styling individual slides with slide-in animation */
        .slide {
            display: none;
            transform: translateX(100%);
            transition: transform 0.5s ease-in-out;
        }
        /* Ensuring active slide is visible and positioned correctly */
        .slide.active {
            display: block;
            transform: translateX(0);
        }
        /* Styling navigation buttons for enhanced UX */
        .slide-nav {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background: #4CAF50;
            color: #ffffff;
            padding: 12px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 24px;
            transition: background 0.3s, transform 0.2s;
            z-index: 100;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        /* Positioning for prev and next buttons */
        .prev {
            left: 10px;
        }
        .next {
            right: 10px;
        }
        /* Hover effect for interactivity */
        .slide-nav:hover {
            background: #388E3C;
            transform: scale(1.15) translateY(-50%);
        }
        /* Styling similar item cards with fixed height and attractive effects */
        .similar-item {
            transition: transform 0.3s, box-shadow 0.3s, border 0.3s;
            height: 340px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            background: #fff;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            padding: 16px;
        }
        /* Adding hover effect with scale, shadow, and glowing border */
        .similar-item:hover {
            transform: scale(1.05);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
            border-color: #4CAF50;
        }
        /* Ensuring images have fixed dimensions */
        .similar-item img {
            width: 128px;
            height: 128px;
            object-fit: cover;
            border-radius: 4px;
        }
        /* Styling descriptions to fit two sentences */
        .similar-item .description {
            font-size: 14px;
            color: #4b5563;
            height: 2.8em;
            overflow: hidden;
        }
        /* Styling "See More" button for professional look */
        .see-more-btn {
            color: #4CAF50;
            font-size: 14px;
            font-weight: 500;
            text-decoration: underline;
            cursor: pointer;
            text-align: center;
            transition: color 0.2s;
        }
        .see-more-btn:hover {
            color: #388E3C;
        }
        /* Styling description modal to match image preview modal */
        .description-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }
        .description-modal-content {
            background: white;
            padding: 20px;
            border-radius: 8px;
            max-width: 500px;
            width: 90%;
            max-height: 80vh;
            overflow-y: auto;
            position: relative;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        }
        .description-modal-content h3 {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 12px;
            color: #1f2937;
        }
        .description-modal-content p {
            font-size: 14px;
            color: #4b5563;
            line-height: 1.5;
        }
        .description-modal-content button {
            background: #4CAF50;
            color: white;
            padding: 8px 16px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
            margin-top: 12px;
            transition: background 0.2s;
        }
        .description-modal-content button:hover {
            background: #388E3C;
        }
        /* Styling dot navigation for slideshow */
        .dot-container {
            text-align: center;
            padding: 12px 0;
        }
        .dot {
            height: 14px;
            width: 14px;
            background-color: #d1d5db;
            border-radius: 50%;
            display: inline-block;
            margin: 0 8px;
            cursor: pointer;
            transition: background-color 0.3s, transform 0.2s;
        }
        .dot:hover {
            transform: scale(1.2);
        }
        .dot.active {
            background-color: #4CAF50;
            transform: scale(1.2);
        }
        /* Styling enhanced success message popup */
        .success-message {
            position: fixed;
            top: -100px; /* Start off-screen */
            right: 20px;
            background: #ffffff;
            color: #1f2937;
            padding: 16px 24px;
            border-radius: 8px;
            z-index: 1000;
            opacity: 0;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            display: flex;
            align-items: center;
            gap: 12px;
            max-width: 300px;
            transition: opacity 0.3s ease-in-out, top 0.3s ease-in-out;
        }
        .success-message.show {
            opacity: 1;
            top: 20px; /* Slide in to visible position */
        }
        .success-message i {
            color: #4CAF50;
            font-size: 24px;
        }
        .success-message p {
            font-size: 14px;
            font-weight: 500;
        }
        .success-message .close-btn {
            background: none;
            color: #6b7280;
            font-size: 16px;
            cursor: pointer;
            padding: 0;
            margin-left: auto;
            transition: color 0.2s;
        }
        .success-message .close-btn:hover {
            color: #1f2937;
        }
        /* Responsive adjustments for smaller screens */
        @media (max-width: 768px) {
            .slide-nav {
                padding: 12px;
                font-size: 22px;
            }
            .prev {
                left: 10px;
            }
            .next {
                right: 10px;
            }
            .similar-item {
                height: 360px;
            }
            .description-modal-content {
                width: 95%;
                padding: 15px;
            }
            .success-message {
                right: 10px;
                max-width: 90%;
            }
        }
    </style>
</head>
<body class="bg-gray-100 font-roboto">
    <!-- Adding home button to return to index.html -->
    <div class="fixed top-4 left-4 z-[9999]">
        <a href="index.html" class="home-button">
            <img src="assets/home.png" alt="Home" class="w-8 h-8 inline-block align-middle">
        </a>
    </div>

    <!-- Main cart container with professional styling -->
    <div class="cart-container max-w-6xl mx-auto bg-white p-6 rounded-lg shadow-md mt-16">
        <!-- Cart header with title -->
        <div class="cart-header">
            <h2 class="text-2xl font-bold text-gray-800">Shopping Cart</h2>
        </div>

        <!-- Cart items section for displaying cart contents -->
        <div id="cart-items"></div>

        <!-- Cart footer with total and proceed button -->
        <div class="cart-footer flex justify-end items-center">
            <h3 class="text-lg font-bold mr-4 text-gray-800">Total: LKR <span id="cart-total">0.00</span></h3>
            <a href="user_details.php" id="proceed-btn" class="bg-green-500 text-white px-6 py-3 rounded-md hover:bg-green-600 transition">Proceed to Checkout</a>
        </div>

        <!-- Similar items section with professional slideshow -->
        <div class="similar-items">
            <h2 class="text-xl font-bold my-4 text-gray-800">Also Recommended</h2>
            <!-- Creating slideshow container for recommended items -->
            <div class="slideshow-container">
                <!-- Navigation buttons with Font Awesome icons -->
                <div class="slide-nav prev" onclick="changeSlide(-1, 'left')"><i class="fas fa-chevron-left"></i></div>
                <div class="slide-nav next" onclick="changeSlide(1, 'right')"><i class="fas fa-chevron-right"></i></div>
            </div>
            <!-- Adding dot navigation for slideshow -->
            <div class="dot-container"></div>
        </div>
    </div>

    <!-- Enhanced success message container -->
    <div id="success-message" class="success-message" role="alert" aria-live="polite">
        <i class="fas fa-check-circle"></i>
        <p>Item added to cart successfully!</p>
        <button class="close-btn" onclick="hideSuccessMessage()" aria-label="Close success message"><i class="fas fa-times"></i></button>
    </div>

    <!-- Image preview modal for enlarged image view -->
    <div class="image-preview-modal" id="image-preview-modal">
        <img src="" alt="Preview" id="preview-image">
        <button onclick="closePreview()">Close</button>
    </div>

    <!-- Description modal for full item descriptions -->
    <div class="description-modal" id="description-modal">
        <div class="description-modal-content">
            <h3 id="modal-item-name"></h3>
            <p id="modal-item-description"></p>
            <button onclick="closeDescriptionModal()">Close</button>
        </div>
    </div>

    <script>
        // Initialize cart from localStorage or default cart
        let cart = JSON.parse(localStorage.getItem('cart')) || <?php echo json_encode($default_cart); ?>;
        const similarItems = <?php echo json_encode($similar_items); ?>;
        localStorage.setItem('cart', JSON.stringify(cart));

        // Render cart items dynamically, excluding description for minimal display
        function renderCart() {
            const cartItems = document.getElementById('cart-items');
            cartItems.innerHTML = '';
            cart.forEach(item => {
                const isMainItem = item.id === 1;
                cartItems.innerHTML += `
                    <div class="cart-item flex items-center py-4 border-b" data-id="${item.id}">
                        <img src="${item.image}" alt="${item.name}" class="w-20 h-20 object-cover mr-4 rounded">
                        <div class="flex-1">
                            <h3 class="text-lg font-medium text-gray-800">${item.name}</h3>
                        </div>
                        <div class="text-black font-bold mr-6">LKR <span class="item-price">${item.price.toFixed(2)}</span></div>
                        <div class="cart-item-actions">
                            <div class="quantity-control flex items-center">
                                <button onclick="updateQuantity(${item.id}, -1)" class="w-8 h-8 border bg-gray-100 rounded">-</button>
                                <input type="number" value="${item.quantity}" min="${isMainItem ? 5 : 1}" class="w-12 text-center border mx-2 rounded" onchange="updateQuantity(${item.id}, 0, this.value)">
                                <button onclick="updateQuantity(${item.id}, 1)" class="w-8 h-8 border bg-gray-100 rounded">+</button>
                            </div>
                            ${isMainItem ? '' : `<button onclick="removeItem(${item.id})" class="remove-button text-red-500 hover:text-red-600">Remove</button>`}
                        </div>
                    </div>
                `;
            });
            updateTotal();
        }

        // Show success message with slide-in animation
        function showSuccessMessage() {
            const successMessage = document.getElementById('success-message');
            successMessage.classList.add('show');
            // Auto-hide after 3 seconds
            setTimeout(() => {
                hideSuccessMessage();
            }, 3000);
        }

        // Hide success message with slide-out animation
        function hideSuccessMessage() {
            const successMessage = document.getElementById('success-message');
            successMessage.classList.remove('show');
        }

        // Add similar item to cart
        function addToCart(id) {
            const item = similarItems.find(item => item.id === id);
            if (item && !cart.find(cartItem => cartItem.id === id)) {
                cart.push({ ...item, quantity: 1 });
                localStorage.setItem('cart', JSON.stringify(cart));
                renderCart();
                showSuccessMessage(); // Show enhanced success message
            }
        }

        // Update item quantity in the cart
        function updateQuantity(id, change, newValue = null) {
            const item = cart.find(item => item.id === id);
            const minQuantity = item.id === 1 ? 5 : 1; // Enforce minimum quantity of 5 for Swastha Amurtha
            if (newValue !== null) {
                item.quantity = Math.max(minQuantity, parseInt(newValue) || minQuantity);
            } else {
                item.quantity = Math.max(minQuantity, item.quantity + change);
            }
            localStorage.setItem('cart', JSON.stringify(cart));
            renderCart();
        }

        // Remove item from cart (except Swastha Amurtha)
        function removeItem(id) {
            if (id !== 1) {
                cart = cart.filter(item => item.id !== id);
                localStorage.setItem('cart', JSON.stringify(cart));
                renderCart();
            }
        }

        // Update total price and proceed button URL with filtered cart data
        function updateTotal() {
            const total = cart.reduce((sum, item) => sum + item.price * item.quantity, 0);
            document.getElementById('cart-total').textContent = total.toFixed(2);
            // Filter cart to include only name, quantity, and price
            const filteredCart = cart.map(item => ({
                name: item.name,
                quantity: item.quantity,
                price: item.price
            }));
            const cartData = encodeURIComponent(JSON.stringify(filteredCart));
            document.getElementById('proceed-btn').href = `user_details.php?cart=${cartData}&total=${total.toFixed(2)}`;
        }

        // Show image preview in modal
        function showPreview(imageSrc) {
            const modal = document.getElementById('image-preview-modal');
            const previewImage = document.getElementById('preview-image');
            previewImage.src = imageSrc;
            modal.style.display = 'flex';
        }

        // Close image preview modal
        function closePreview() {
            const modal = document.getElementById('image-preview-modal');
            modal.style.display = 'none';
        }

        // Show full description in modal
        function showDescription(id) {
            console.log('showDescription called with id:', id); // Debugging log
            const item = similarItems.find(item => item.id === id);
            if (item) {
                const modal = document.getElementById('description-modal');
                const itemName = document.getElementById('modal-item-name');
                const itemDescription = document.getElementById('modal-item-description');
                itemName.textContent = item.name;
                itemDescription.innerHTML = item.description; // Support HTML tags
                modal.style.display = 'flex'; // Ensure modal is displayed
            } else {
                console.error('Item not found for id:', id); // Log if item is not found
            }
        }

        // Close description modal
        function closeDescriptionModal() {
            const modal = document.getElementById('description-modal');
            modal.style.display = 'none';
        }

        // Truncate description to two sentences
        function truncateDescription(text) {
            const tempDiv = document.createElement('div');
            tempDiv.innerHTML = text;
            const plainText = tempDiv.textContent || tempDiv.innerText;
            const sentences = plainText.match(/[^.!?]+[.!?]+/g) || [plainText];
            return sentences.slice(0, 2).join(' ').trim();
        }

        // Implementing professional slideshow with 3 cards per slide
        const slideshowContainer = document.querySelector('.slideshow-container');
        const dotContainer = document.querySelector('.dot-container');
        let currentSlide = 0;
        let isSliding = false; // Flag to prevent rapid clicks
        let lastDirection = 'right'; // Track last slide direction for animation

        // Grouping similar items into chunks of 3 for each slide
        function chunkArray(array, size) {
            const result = [];
            for (let i = 0; i < array.length; i += size) {
                result.push(array.slice(i, i + size));
            }
            return result;
        }

        // Rendering slides and navigation dots dynamically
        function renderSlides() {
            const isMobile = window.innerWidth <= 768; // You can adjust this breakpoint as needed
            const itemsPerSlide = isMobile ? 1 : 3;

            const slides = chunkArray(similarItems, itemsPerSlide);
            // const slides = chunkArray(similarItems, 3);
            slideshowContainer.innerHTML = `
                <div class="slide-nav prev" onclick="changeSlide(-1, 'left')"><i class="fas fa-chevron-left"></i></div>
                <div class="slide-nav next" onclick="changeSlide(1, 'right')"><i class="fas fa-chevron-right"></i></div>
            `;
            // Creating slides with grid layout
            slides.forEach((slideItems, index) => {
                const slide = document.createElement('div');
                slide.className = `slide ${index === 0 ? 'active' : ''}`;
                slide.innerHTML = `
                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 px-6">
                        ${slideItems.map(item => `
                            <div class="similar-item">
                                <img src="${item.image}" alt="${item.name}" class="mx-auto mb-3" onclick="showPreview('${item.image}')">
                                <h3 class="text-base font-semibold text-gray-800">${item.name}</h3>
                                <p class="description mb-2">${truncateDescription(item.description)}</p>
                                <p class="see-more-btn" onclick="showDescription(${item.id})">See More</p>
                                <p class="price font-semibold text-gray-800">LKR ${item.price.toFixed(2)}</p>
                                <button onclick="addToCart(${item.id})" class="bg-green-500 text-white px-4 py-2 rounded-md hover:bg-green-600 transition">Add to Cart</button>
                            </div>
                        `).join('')}
                    </div>
                `;
                slideshowContainer.appendChild(slide);
            });
            // Rendering navigation dots
            dotContainer.innerHTML = slides.map((_, index) => `
                <span class="dot ${index === 0 ? 'active' : ''}" onclick="goToSlide(${index})"></span>
            `).join('');
        }

        // Showing the specified slide with direction-based animation
        function showSlide(index, direction = 'right') {
            if (isSliding) return; // Prevent rapid slide changes
            isSliding = true;
            const slides = document.querySelectorAll('.slide');
            const dots = document.querySelectorAll('.dot');
            // Set animation direction
            slides.forEach((slide, i) => {
                if (i === index) {
                    slide.classList.add('active');
                    slide.style.transform = `translateX(${direction === 'right' ? '0' : '0'})`;
                } else {
                    slide.classList.remove('active');
                    slide.style.transform = `translateX(${direction === 'right' ? '-100%' : '100%'})`;
                }
            });
            dots.forEach((dot, i) => {
                dot.classList.toggle('active', i === index);
            });
            currentSlide = index;
            lastDirection = direction;
            setTimeout(() => isSliding = false, 500); // Debounce for 500ms
        }

        // Changing slides based on direction with animation
        function changeSlide(direction, slideDirection) {
            const slides = document.querySelectorAll('.slide');
            let newIndex = currentSlide + direction;
            if (newIndex < 0) newIndex = slides.length - 1;
            if (newIndex >= slides.length) newIndex = 0;
            showSlide(newIndex, slideDirection);
        }

        // Going to a specific slide via dot navigation
        function goToSlide(index) {
            const direction = index > currentSlide ? 'right' : 'left';
            showSlide(index, direction);
        }

        // Initializing slideshow
        renderSlides();
        showSlide(currentSlide);

        // Initial render of cart
        renderCart();
    </script>
</body>
</html>