<?php
session_start();

// Database connection details
require('../dbconfig/dbconfig.php'); 


// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // Prepare and execute query to find user by email
    $stmt = $conn->prepare("SELECT * FROM tblAdmin WHERE userName = ?");
    $stmt->bind_param("s", $email);  // 's' indicates the parameter is a string
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        
        // Verify the password using password_verify (assuming password is hashed)
        // if ( $password === $user['password']) {
        if (password_verify($password, $user['password'])) {
            // Successful login
            $_SESSION['logged_in'] = true;
            $_SESSION['email'] = $user['email'];
            header("Location: Admin.php"); // Redirect to Admin.php after successful login
            exit();
        } else {
            $error = "Incorrect password.";
        }
    } else {
        $error = "No user found with that email address.";
    }

    $stmt->close();
}

?>
