<?php
require('../dbconfig/dbconfig.php'); 
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="styles/admin.css">
    <link rel="icon" type="image/x-icon" href="../assets/logo.png">
    <title>Admin Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="assets/logo.png">
    <link rel="stylesheet"
        href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">

    <!-- Boostrap import link -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
</head>

<body>
    <div class="container">
        <h2>User Details</h2>
        <div class="buttonl-container">
            <a href="logout.php" class="btn btn-logout">Log Out</a>
        </div>
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>NIC number/th>
                    <th>DOB</th>
                    <th>Contact Number</th>
                    <th>Province</th>
                    <th>District</th>
                    <th>Page screenshot</th>
                    <th>Profile screenshot</th>
                </tr>
            </thead>
            <tbody>
            <?php
                // Fetch user details from the users table
                $sql = "SELECT id, name, id_no, dob, contact_no, province, district, page_screenshot, profile_image FROM users";
                $result = $conn->query($sql);

                if ($result->num_rows > 0) {
                    // Output data of each row
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . $row["id"] . "</td>";
                        echo "<td>" . $row["name"] . "</td>";
                        echo "<td>" . $row["id_no"] . "</td>";
                        echo "<td>" . $row["dob"] . "</td>";
                        echo "<td>" . $row["contact_no"] . "</td>";
                        echo "<td>" . $row["province"] . "</td>";
                        echo "<td>" . $row["district"] . "</td>";
                        echo "<td><img src='" . $row["page_screenshot"] . "' alt='Page Screenshot' width='100'></td>";
                        echo "<td><img src='" . $row["profile_image"] . "' alt='Profile Screenshot' width='100'></td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='9'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>

    </div>

</body>
</html>

<?php
// Close the database connection if initialized
if (isset($conn)) {
    $conn->close();
}
?>