<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require('../dbconfig/dbconfig.php'); 

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php"); // Redirect to the login page
    exit;
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="styles/admin.css">
    <link rel="icon" type="image/x-icon" href="../assets/logo.png">
    <title>Admin Panel</title>
    <link rel="stylesheet"
        href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
</head>

<body>
    <div class="container">
        <h2>User Details</h2>
        <div class="buttonl-container">
            <a href="DashBoard.php" class="btn btn-logout">Back</a>
            <a href="logout.php" class="btn btn-logout">Log Out</a>
        </div>
        
        <!-- Search input -->
        <div style="width:100%; display:flex; justify-content:space-between; align-items:center; margin-top:20px">
            <input style="width:30%; " type="text" id="searchInput" class="form-control" placeholder="Search...">
            <a href="download_csv.php" class="create-admin-btn" style="text-decoration: none; color:black">Download a report</a>
        </div>

        <table class="table table-bordered table-striped mt-3">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>NIC Number</th>
                    <th>DOB</th>
                    <th>Contact Number</th>
                    <th>Province</th>
                    <th>District</th>
                </tr>
            </thead>
            <tbody id="userTable">
            <?php
                // Fetch user details from the `users` table
                $sql = "SELECT id, name, id_number, CAST(dob AS DATE) AS dob, contact_no, province, district FROM users";
                $result = $conn->query($sql);

                if ($result->num_rows > 0) {
                    // Output data of each row
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . $row["id"] . "</td>";
                        echo "<td>" . $row["name"] . "</td>";
                        echo "<td>" . $row["id_number"] . "</td>";
                        echo "<td>" . $row["dob"] . "</td>";
                        echo "<td>" . $row["contact_no"] . "</td>";
                        echo "<td>" . $row["province"] . "</td>";
                        echo "<td>" . $row["district"] . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='9'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // JavaScript for search functionality
        document.getElementById('searchInput').addEventListener('keyup', function () {
            let filter = this.value.toLowerCase();
            let rows = document.querySelectorAll('#userTable tr');

            rows.forEach(function (row) {
                let cells = row.getElementsByTagName('td');
                let match = false;

                // Check each cell for a match
                for (let i = 0; i < cells.length; i++) {
                    if (cells[i] && cells[i].textContent.toLowerCase().indexOf(filter) > -1) {
                        match = true;
                        break;
                    }
                }

                // Show or hide the row based on the match
                row.style.display = match ? '' : 'none';
            });
        });
    </script>
</body>
</html>

<?php
// Close the database connection if initialized
if (isset($conn)) {
    $conn->close();
}
?>
