<?php
// Start session
session_start();

// Database connection details
require 'dbconfig/dbconfig.php';

header('Content-Type: application/json');

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Initialize response array
    $response = [];

    // Get user ID and prize
    $user_id = $_POST['user_id'];
    $prize = $_POST['prize'];
    
    // Insert data into the database
    $stmt = $conn->prepare("INSERT INTO winners (user_id, prize) VALUES (?, ?)");
    $stmt->bind_param("ss", $user_id, $prize);

    if ($stmt->execute()) {
        $spinID = $stmt->insert_id; // Get last inserted ID
        $_SESSION['spin_id'] = $spinID; // Store in session
       
        $response = [
            "status" => "success",
            "message" => "Successfully inserted",
            "userID" => $spinID
        ];

    } else {
        $response = ["status" => "error", "message" => "Database error: " . $stmt->error];
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();

    // Send response
    echo json_encode($response);
} else {
    // If not a POST request
    $response = ["status" => "error", "message" => "Invalid request method"];
    echo json_encode($response);
}
?>
